---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-RDD Detail（RDD詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` （RDDPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` （StorageTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.8の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.8の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /storage/rdd/?id={rddId} | E-01 (33行目: WebUIPage("rdd")) | ○ |
| C-02 | idパラメータが必須 | E-01 (36-37行目: require) | ○ |
| C-03 | store.rdd(rddId)でRDD情報取得 | E-01 (43行目) | ○ |
| C-04 | RDD未発見時"RDD Not Found"ページ表示 | E-01 (45-47行目: NoSuchElementException catch) | ○ |
| C-05 | Executor分布テーブルのカラムは4つ | E-01 (133-137行目: workerHeader) | ○ |
| C-06 | OnHeap/OffHeapメモリ使用量と残量を表示 | E-01 (140-153行目: workerRow) | ○ |
| C-07 | パーティションテーブルのカラムは5つ | E-01 (250-255行目: blockHeaders) | ○ |
| C-08 | 全5カラムがソート可能 | E-01 (255行目: map(x => (x, true, None))) | ○ |
| C-09 | ソートカラムデフォルトは"Block Name" | E-01 (217行目: getTableParameters default) | ○ |
| C-10 | ExecutorIdをhostPortに変換 | E-01 (183-186行目: executorIdToAddress.getOrElse) | ○ |
| C-11 | executorList(true)で全Executor取得 | E-01 (60行目) | ○ |
| C-12 | テーブルレンダリングエラー時alert表示 | E-01 (62-64行目: catch) | ○ |
| C-13 | ソート指定時自動スクロール | E-01 (67-81行目: jQuery animate) | ○ |
| C-14 | テーブルIDは"rdd-storage-by-block-table" | E-01 (219行目) | ○ |
| C-15 | ページタイトルは"RDD Storage Info for {name}" | E-01 (128-129行目) | ○ |
| C-16 | RDD基本情報5項目を表示 | E-01 (86-107行目: Storage Level, Cached/Total Partitions, Memory/Disk Size) | ○ |
| C-17 | Data Distribution on {N} Executorsのヘッダー | E-01 (114行目: rddStorageInfo.dataDistribution.map(_.size)) | ○ |
| C-18 | {N} Partitionsのヘッダー | E-01 (123行目: rddStorageInfo.partitions.map(_.size)) | ○ |
| C-19 | BlockDataSourceのソートロジック5パターン | E-01 (193-207行目: ordering) | ○ |
| C-20 | 不正なソートカラム名で例外 | E-01 (200行目: IllegalArgumentException) | ○ |
| C-21 | workerテーブルIDは"rdd-storage-by-worker-table" | E-01 (52行目: id = Some("rdd-storage-by-worker-table")) | ○ |
| C-22 | ページサイズフォームフィールド名はblock.pageSize | E-01 (224行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RDDPage.scalaの全処理が直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] OnHeap/OffHeapメモリ表示のフォーマットが正確か確認
- [ ] Executor一覧取得時のactiveOnlyフラグ（true）の意味を確認
